/*global ol,$,document,window */

// so, if I use jqueryUI's buttons and leave everything else in place things seem to work fine so far
//it does feel like a horrible idea though.
(function () {
    $.fn.bootstrapBtn = $.fn.button.noConflict();
}) ();

/*Drag-adn-Drop Part I */

var modifiedKMLConstr = function () {
    "use strict";
    return new ol.format.KML({'extractStyles': false, 'showPointNames': true});
};

var dragAndDropInteraction = new ol.interaction.DragAndDrop({
        formatConstructors: [
            ol.format.GPX,
            ol.format.GeoJSON,
            ol.format.IGC,
            modifiedKMLConstr,
            ol.format.TopoJSON
        ]
    });

var projection = ol.proj.get('EPSG:3857');
var projectionExtent = projection.getExtent();
var size = ol.extent.getWidth(projectionExtent) / 256;
var resolutions = new Array(14);
var matrixIds = new Array(14);
for (var z = 0; z < 14; ++z) {
	// generate resolutions and matrixIds arrays for this WMTS
	resolutions[z] = size / Math.pow(2, z);
	matrixIds[z] = z;
}

var map = new ol.Map({
	interactions: ol.interaction.defaults().extend([dragAndDropInteraction]),
	controls: ol.control.defaults().extend([
		new ol.control.ScaleLine({
			 units: 'metric'
		}),
		new ol.control.MousePosition({
			//coordinateFormat: ol.coordinate.createStringXY(6),
			coordinateFormat: function(coordinate) {return ol.coordinate.format(coordinate, '{y}, {x}', 6);},
                	projection: 'EPSG:4326'
		})
	]),
	layers: [
		new ol.layer.Tile({
			shortTitle: 'orm',
			title: 'Open Railway Map',
			zIndex: '1',
			visible: false,
			source: new ol.source.OSM({
				attributions: '<a href="https://www.openrailwaymap.org/" target="_blank">openrailwaymap.org</a>',
				url: "https://{a-c}.tiles.openrailwaymap.org/standard//{z}/{x}/{y}.png",
				crossOrigin: null
			})
		}),
		new ol.layer.Tile({
			shortTitle: 'hk',
			title: 'Hiking',
			zIndex: '1',
			visible: false,
			source: new ol.source.OSM({
				attributions: '<a href="https://hiking.waymarkedtrails.org/" target="_blank">waymarkedtrails.org</a>',
				url: "https://tile.waymarkedtrails.org/hiking/{z}/{x}/{y}.png",
				crossOrigin: null
			})
		}),
		new ol.layer.Tile({
			shortTitle: 'otm',
			title: 'Open Topo Map',
			type: 'base',
			source: new ol.source.OSM({
				attributions: '&copy; <a href="https://www.openstreetmap.org/copyright" target="_blank">OpenStreetMap</a> contributors' +
						', ' +
						'<a href="https://opentopomap.org" target="_blank">OpenTopoMap</a> (<a href="https://creativecommons.org/licenses/by-sa/3.0/" target="_blank">CC-BY-SA</a>)',
				url: 'https://{a-c}.tile.opentopomap.org/{z}/{x}/{y}.png',
				crossOrigin: null
			})
		}),
		new ol.layer.Tile({
			shortTitle: 'osm',
			title: 'Open Street Map',
			type: 'base',
			source: new ol.source.OSM()
		}),
		new ol.layer.Tile({
			shortTitle: 'tm',
			title: 'Tourist Map',
			type: 'base',
			source: new ol.source.OSM({
				attributions: '&copy;<a href="https://www.seznam.cz/" target="_blank">Seznam.cz a.s.</a>' +
						', ' +
						'&copy;<a href="https://www.openstreetmap.org/copyright" target="_blank">OpenStreetMap</a>',
				url: 'https://tiles.windy.com/v1/maptiles/outdoor/256/{z}/{x}/{y}.png',
				crossOrigin: null
			})
		}),
		new ol.layer.Tile({
			shortTitle: 'SEEtopo',
                        title: 'SEEtopo',
			type: 'base',
			source: new ol.source.TileWMS(({/** @type {olx.source.TileWMSOptions} */
				attributions: '<a href="https://cart.uni-plovdiv.net/" target="_blank">CART Lab</a>',
				url: 'https://kade.si/cgi-bin/mapserv?',
				serverType: 'mapserver',
				preload: 0,
				params: {'LAYERS': 'SEEtopo', 'TILED': true, 'format': 'image/vnd.jpeg-png'}
			}))
		}),
		new ol.layer.Tile({
			shortTitle: 'gkme',
			title: 'GkME-200k',
			type: 'base',
			source: new ol.source.TileWMS(({/** @type {olx.source.TileWMSOptions} */
				attributions: '<a href="https://cart.uni-plovdiv.net/" target="_blank">CART Lab</a>',
				url: 'https://kade.si/cgi-bin/mapserv?',
				serverType: 'mapserver',
				preload: 0,
				params: {'LAYERS': 'GkME-200k', 'TILED': true, 'format': 'image/vnd.jpeg-png'}
			}))
		}),
		new ol.layer.Tile({
			shortTitle: 'bgt1884',
			title: 'BGtopo-210k',
			type: 'base',
			source: new ol.source.TileWMS(({/** @type {olx.source.TileWMSOptions} */
				attributions: '<a href="https://cart.uni-plovdiv.net/" target="_blank">CART Lab</a>',
				url: 'https://kade.si/cgi-bin/mapserv?',
				serverType: 'mapserver',
				preload: 0,
				params: {'LAYERS': 'BGtopo-210k', 'TILED': true, 'format': 'image/vnd.jpeg-png'}
			}))
		}),
		new ol.layer.Tile({
			shortTitle: 'bgt1878',
			title: 'BGtopo-126k',
			type: 'base',
			source: new ol.source.TileWMS(({/** @type {olx.source.TileWMSOptions} */
				attributions: '<a href="https://cart.uni-plovdiv.net/" target="_blank">CART Lab</a>',
				url: 'https://kade.si/cgi-bin/mapserv?',
				serverType: 'mapserver',
				preload: 0,
				params: {'LAYERS': 'BGtopo-126k', 'TILED': true, 'format': 'image/vnd.jpeg-png'}
			}))
		}),
		new ol.layer.Tile({
			shortTitle: 'bgt1933',
			title: 'BGtopo-1933',
			type: 'base',
			source: new ol.source.TileWMS(({/** @type {olx.source.TileWMSOptions} */
				attributions: '<a href="https://cart.uni-plovdiv.net/" target="_blank">CART Lab</a>',
				url: 'https://kade.si/cgi-bin/mapserv?',
				serverType: 'mapserver',
				preload: 0,
				params: {'LAYERS': 'BGtopo-1933', 'TILED': true, 'format': 'image/vnd.jpeg-png'}
			}))
		}),
		new ol.layer.Tile({
			shortTitle: 'BG5K',
			title: 'ETK-1-5000',
			type: 'base',
			source: new ol.source.TileWMS(({/** @type {olx.source.TileWMSOptions} */
				attributions: '<a href="https://cart.uni-plovdiv.net/" target="_blank">CART Lab</a>',
				url: 'https://kade.si/cgi-bin/mapserv?',
				serverType: 'mapserver',
				preload: 0,
				params: {'LAYERS': 'ETK-1-5000', 'TILED': true, 'format': 'image/vnd.jpeg-png'}
			}))
		}),
		new ol.layer.Tile({
			shortTitle: 'BG50K',
			title: 'BGtopoVJ-50K',
			type: 'base',
			source: new ol.source.TileWMS(({/** @type {olx.source.TileWMSOptions} */
				attributions: '<a href="https://cart.uni-plovdiv.net/" target="_blank">CART Lab</a>',
				url: 'https://kade.si/cgi-bin/mapserv?',
				serverType: 'mapserver',
				preload: 0,
				params: {'LAYERS': 'BGtopoVJ-raster-v3.00', 'TILED': true, 'format': 'image/vnd.jpeg-png'}
			}))
		}),
		new ol.layer.Tile({
			shortTitle: 'BG100K',
			title: 'BGtopo-100K',
			type: 'base',
			source: new ol.source.TileWMS(({/** @type {olx.source.TileWMSOptions} */
				attributions: '<a href="https://cart.uni-plovdiv.net/" target="_blank">CART Lab</a>',
				url: 'https://kade.si/cgi-bin/mapserv?',
				serverType: 'mapserver',
				preload: 0,
				params: {'LAYERS': 'BGtopo-100k', 'TILED': true, 'format': 'image/vnd.jpeg-png'}
			}))
		}),
		new ol.layer.Tile({
			shortTitle: 's2',
			title: 'Sentinel-2',
			type: 'base',
			source: new ol.source.WMTS({
				attributions: '<a href="https://s2maps.eu/" target="_blank">Sentinel-2 cloudless</a> by <a href="https://eox.at/" target="_blank">EOX</a> (Contains modified <a href="https://sentinels.copernicus.eu/web/sentinel/missions/sentinel-2" target="_blank">Copernicus Sentinel-2</a> data 2022)',
				tileGrid: new ol.tilegrid.WMTS({
					origin: ol.extent.getTopLeft(projectionExtent),
					resolutions: resolutions,
					matrixIds: matrixIds
				}),
				url: 'https://s2maps-tiles.eu/wmts?',
				layer: 's2cloudless-2022_3857',
				style: 'default',
				matrixSet: 'GoogleMapsCompatible',
				crossOrigin: null
			})
		}),
		/*new ol.layer.Tile({
			shortTitle: 'bing',
			title: 'Bing Hybrid',
			type: 'base',
			source: new ol.source.BingMaps({
				//key: 'AslT_8wrLp_jVe4n6fYZajm0jUZ1hFcVYqRdbISgbkXJ9qmKoL-WYAB2Lj8ML7XV',
				key: 'ArWfnxvEPy_H9zkO0YJm1_5qwSZYCfWSwGQoVxFi5TLiOmUf1jUUSvSPv9uGyu8A',
				imagerySet: 'AerialWithLabels'
			})
		}),*/
		new ol.layer.Tile({
			shortTitle: 'ghyb',
			title: 'Google Hybrid',
			type: 'base',
			source: new ol.source.OSM({
				attributions: 'Imagery &copy; <a href="https://maps.google.com/" target="_blank">Google</a>' +
						', ' +
						'Map data &copy; <a href="https://maps.google.com/" target="_blank">Google</a>',
				url: 'https://mt{0-3}.google.com/vt/lyrs=s,h&x={x}&y={y}&z={z}',
				crossOrigin: null
			})
		}),
		new ol.layer.Tile({
			shortTitle: 'av',
			title: 'Aerial View',
			type: 'base',
			source: new ol.source.TileWMS(({/** @type {olx.source.TileWMSOptions} */
				attributions: '<a href="https://cart.uni-plovdiv.net/" target="_blank">CART Lab</a>',
				url: 'https://kade.si/cgi-bin/mapserv?',
				serverType: 'mapserver',
				preload: 0,
				params: {'LAYERS': 'orthophoto-BG-2024', 'TILED': true, 'format': 'image/vnd.jpeg-png'}
			}))
		}),
		new ol.layer.Tile({
			shortTitle: 'map',
			title: 'BGMountains',
			type: 'base',
			source: new ol.source.OSM({
				attributions: '<a href="http://mountain.bajhui.org/trac/wiki/BGMountains%20%D0%BB%D0%B5%D0%B3%D0%B5%D0%BD%D0%B4%D0%B0" target="_blank">BGM Legend</a>' +
						' / ' +
						'<a href="https://cart.uni-plovdiv.net/" target="_blank">CART Lab</a>' +
						', ' +
						'<a href="http://www.bgmountains.org/" target="_blank">BGM team</a>' +
						', ' +
						'Tiles &copy; <a href="https://creativecommons.org/licenses/by-sa/4.0/" target="_blank">CC BY-SA 4.0</a>' +
						', ' +
						'<a href="http://bgmountains.org/en/maps/garmin-maps/category/9-bgmountains/" target="_blank">Garmin version</a>',
				url: 'https://bgmtile.kade.si/{z}/{x}/{y}.png',
				crossOrigin: null
			})
		})
        ],
	renderer: 'canvas',
	target: 'map',
	view: new ol.View({
		minZoom: 3,
		maxZoom: 19,
		center: [2810000, 5250000],
		rotation: 0,
		zoom: 8
        }),
	loadTilesWhileAnimating: true,
	loadTilesWhileInteracting: true
});

// Geocoder Nominatim for OpenLayers

  // Instantiate with some options and add the Control
  var geocoder = new Geocoder('nominatim', {
    provider: 'osm',
    //key: 'AslT_8wrLp_jVe4n6fYZajm0jUZ1hFcVYqRdbISgbkXJ9qmKoL-WYAB2Lj8ML7XV',
    //key: 'ArWfnxvEPy_H9zkO0YJm1_5qwSZYCfWSwGQoVxFi5TLiOmUf1jUUSvSPv9uGyu8A',
    targetType: 'glass-button',
    //targetType: text-input,
    lang: 'bg-BG',
    placeholder: 'Search for ...',
    limit: 10,
    //autoComplete: true,
    //autoCompleteMinLength: 2,
    //autoCompleteTimeout : 200,
    keepOpen: false
  });

  popup = new ol.Overlay.Popup();
  map.addControl(geocoder);
  map.addOverlay(popup);

  // Listen when an address is chosen
  geocoder.on('addresschosen', function (evt) {
    window.setTimeout(function () {
      popup.show(evt.coordinate, evt.address.formatted);
    }, 3000);
  });

/*Drag-adn-Drop Part II */
var defaultStyle = {
        'Point': new ol.style.Style({
            image: new ol.style.Circle({
                fill: new ol.style.Fill({
                    color: '#ff0'
                }),
                radius: 5,
                stroke: new ol.style.Stroke({
                    color: '#ff0',
                    width: 1
                })
            })
        }),
        'LineString': new ol.style.Style({
            stroke: new ol.style.Stroke({
                color: '#f00',
                width: 3
            })
        }),
        'Polygon': new ol.style.Style({
            fill: new ol.style.Fill({
                color: 'rgba(0,255,255,0.5)'
            }),
            stroke: new ol.style.Stroke({
                color: '#0ff',
                width: 1
            })
        }),
        'MultiPoint': new ol.style.Style({
            image: new ol.style.Circle({
                fill: new ol.style.Fill({
                    color: 'rgba(255,0,255,0.5)'
                }),
                radius: 5,
                stroke: new ol.style.Stroke({
                    color: '#f0f',
                    width: 1
                })
            })
        }),
        'MultiLineString': new ol.style.Style({
            stroke: new ol.style.Stroke({
                color: '#f0f',
                width: 3
            })
        }),
        'MultiPolygon': new ol.style.Style({
            fill: new ol.style.Fill({
                color: 'rgba(0,0,255,0.5)'
            }),
            stroke: new ol.style.Stroke({
                color: '#00f',
                width: 1
            })
        })
    };

var styleFunction = function (feature, resolution) {
    "use strict";
    var featureStyleFunction = feature.getStyleFunction();
    if (featureStyleFunction) {
        return featureStyleFunction.call(feature, resolution);
    } else {
        var r =  defaultStyle[feature.getGeometry().getType()].clone();
        if(feature.getGeometry().getType() == 'Point'){
            r.setText(new ol.style.Text({
                placement:'point',
                fill: new ol.style.Fill({color: "#000"}),
                offsetY: 22,
                align: 'center',
                scale: 1.3,
                text:feature.get('name'),
                padding:[100,100,100,100],
             //   backgroundFill: new ol.style.Fill({color: "#0a0"}),
                stroke: new ol.style.Stroke({
                    width:3,
                    color:"#fff"
                })
                
            }));
        }
        return r;
    }
};

dragAndDropInteraction.on('addfeatures', function (event) {
    "use strict";
    var vectorSource = new ol.source.Vector({
            features: event.features
        });
    map.addLayer(new ol.layer.Vector({
        shortTitle: "user-data",
        source: vectorSource,
        style: styleFunction
    }));
    map.getView().fit(vectorSource.getExtent());
});

var displayFeatureInfo = function (pixel) {
    "use strict";
    var features = [],
        info = [],
        i,
        ii;
    map.forEachFeatureAtPixel(pixel, function (feature) {
        features.push(feature);
    });
    if (features.length > 0) {
        for (i = 0, ii = features.length; i < ii; i += 1) {
            info.push(features[i].get('name'));
        }
        document.getElementById('info').innerHTML = info.join(', ') || '&nbsp';
    } else {
        document.getElementById('info').innerHTML = '&nbsp;';
    }
};

map.on('pointermove', function (evt) {
    "use strict";
    if (evt.dragging) {
        return;
    }
    var pixel = map.getEventPixel(evt.originalEvent);
    displayFeatureInfo(pixel);
});

map.on('click', function (evt) {
    "use strict";
    displayFeatureInfo(evt.pixel);
});

/*Tooltip */


	
$('.ol-zoom-in, .ol-zoom-out').tooltip({
    placement: 'right'
});
$('.ol-rotate-reset, .ol-attribution button[title]').tooltip({
    placement: 'left'
});

$('#Home').tooltip({'title' : 'Home', 'placement':'auto'});
$('#Upload').tooltip({'title' : 'Upload', 'placement':'auto'})
$('#drawPoint').tooltip({'title' : "Draw Point", 'placement':'auto'});
$('#drawLine').tooltip({'title' : "Draw Polyline", 'placement':'auto'});
$('#drawPolygon').tooltip({'title' : "Draw Polygon", 'placement':'auto'});
$('#Save').tooltip({'title' : "Save", 'placement':'auto'});
$('#Clear').tooltip({'title' : "Clear Drawings", 'placement':'auto'});



/*LayerSwitcher */

var layerSwitcher = new ol.control.LayerSwitcher({
    tipLabel: 'Légende' // Optional label for button
});
map.addControl(layerSwitcher);


//-----------------------------------------
var layers = map.getLayers().getArray(); // this thing is just useful to have around in the next 2 parts

// -------------------------------------------------------
// Permalink setting
//------------------------------------------------------

/*The function makes sure that the anchor is correct*/

var set_anchor = function () {
    "use strict";
    var active_layers = layers.filter(function (layer) { // this get the layers that are currently visible
            return layer.get('visible') && layer.get('shortTitle') !== undefined;
        }),
        active_layer_titles = active_layers.map(function (layer) { // this their abreviated titles
            return layer.get('shortTitle');
        }),
        // then we collect info about the current zoom/coordinates
        view = map.getView(),
        center = view.getCenter(),
        // and then we generate the anchor string
        anchor_string = "#" + // starts with a #
            active_layer_titles.reduce(function (anchor, title) { // followed by comma separated list of active layers
                return anchor + title + ',';
            }, "")
            .slice(0, -1) + // the reduce above will create one extra comma at the end, so we remove the last character
            "=" + // then the equal sign
            view.getZoom() + '/' + // and then the stuff about the current view separated by /
            Math.round(center[0] * 100) / 100 + '/' +
            Math.round(center[1] * 100) / 100 + '/' +
            view.getRotation();
    // now that the anchor is ready we can place it in the address bar of the browser
    window.location.hash = anchor_string;
};
// The address bar has to be changed:
//1) when we switch layers
layers.forEach(function (layer) {
    "use strict";
    // i.e. When one of the layers becomes visible or invisible
    layer.on('change:visible', set_anchor);
});
// 2) when we move the map around
map.on('moveend', set_anchor);
// -------------------------------------------------------
// Permalink reading
//------------------------------------------------------

// Now if the page is called with an anchor we need to read it
var update_location = function () {
    //console.log("dsfds0");
    "use strict";
    if (window.location.hash !== "") { // if we don't have an anchor we can use default values
        var tokens = window.location.hash.slice(1).split(/,|=/),// this splits "#a,b,c=1/2/3/4" into "a", "b", "c" and "1/2/3/4"
            active_titles = tokens.slice(0, -1), // now "a", "b" and "c" are the names of layers and "1/2/3/4" is not, so we take those
            coordinates = tokens[tokens.length - 1], // and then take "1/2/3/4" separately
            coordinate_parts = coordinates.split('/'), // and split it into "1", "2", "3" and "4"
            zoom = 8, // if the URL with the coordinates is wrong (like "a,b,c=sd/adsf2/;43f3"), we use the default values instead
            center = [2810000, 5250000],
            rotation = 0;
        //then we go trough all the layers
        layers.forEach(function (layer) {
            var title = layer.get('shortTitle');
            // And if it's name is in the active_titles list we make it visible, if it's not we make it invisible
            // so if we have layers with short titles "a", "b", "c", "x" x would be invisible and a, b and c visible
            layer.setVisible(active_titles.includes(title) || title === undefined);
        });
        if (coordinate_parts.length === 4) {
            // Then we read the coordinates as numbers
            zoom = parseInt(coordinate_parts[0], 10);
            center = [
                parseFloat(coordinate_parts[1]),
                parseFloat(coordinate_parts[2])
            ];
            rotation = parseFloat(coordinate_parts[3]);
        }
        // and set the map to the values that we read (or if the URL is malformed to the default ones)
        map.getView().setZoom(zoom);
        map.getView().setCenter(center);
        map.getView().setRotation(rotation);
    }
};
// We have to check for an anchor when we load the webpage
update_location();
// Not sure what "popstate" is, just know that this way the back button works
window.addEventListener('popstate', update_location);
// -------------------------------------------------------
// Geolocation
//------------------------------------------------------
	
var geolocation = new ol.Geolocation({
        projection: map.getView().getProjection(),
        trackingOptions: {
          maximumAge: 1000,
          enableHighAccuracy: true,
          timeout: 300000
        }
    });

function el(id) {
    "use strict";
    return document.getElementById(id);
}

el('track').addEventListener('change', function () {
    "use strict";
    geolocation.setTracking(this.checked);
});

// update the HTML page when the position changes.

function round_to(float, decimal_places){
    if(decimal_places === 0){
        return Math.round(float);
    }
    return Math.round(float*decimal_places)/decimal_places;
}
geolocation.on('change', function () {
    "use strict";
    // el('accuracy').innerText = geolocation.getAccuracy() + ' [m]';
    el('altitude').innerText = round_to(geolocation.getAltitude() || 0, 0);
    //el('altitudeAccuracy').innerText = geolocation.getAltitudeAccuracy() + ' [m]';
    //el('heading').innerText = geolocation.getHeading() + ' [rad]';
    el('speed').innerText = round_to((geolocation.getSpeed() || 0) * 3.6, 2);
    map.getView().setCenter(geolocation.getPosition());
});

// handle geolocation error.
geolocation.on('error', function (error) {
    "use strict";
    var info = document.getElementById('info');
    info.innerHTML = error.message;
    info.style.display = '';
});

var accuracyFeature = new ol.Feature();
geolocation.on('change:accuracyGeometry', function () {
    "use strict";
    accuracyFeature.setGeometry(geolocation.getAccuracyGeometry());
});

var positionFeature = new ol.Feature();
positionFeature.setStyle(new ol.style.Style({
    image: new ol.style.Circle({
        radius: 6,
        fill: new ol.style.Fill({
            color: '#3399CC'
        }),
        stroke: new ol.style.Stroke({
            color: '#fff',
            width: 2
        })
    })
}));

geolocation.on('change:position', function () {
    "use strict";
    var coordinates = geolocation.getPosition();
    positionFeature.setGeometry(coordinates ? new ol.geom.Point(coordinates) : null);
});

var vec = new ol.layer.Vector({
    map: map,
    source: new ol.source.Vector({
        features: [accuracyFeature, positionFeature]
    })
});

var onLoadButtonClick = function() {
    $( "#dialog" ).dialog();
  }


var file_formats = {
    "json": new ol.format.GeoJSON(),
    "gpx": new ol.format.GPX(),
    "kml": new ol.format.KML({'extractStyles': false, 'showPointNames': true})
}
$("#loadFormButton").click(function (){
    
    var file = document.getElementById('loadFormFile').files[0]
    var name = file.name;
    var tokens = name.split('.');
    var ext = tokens[tokens.length-1];
   // console.log(file)
    var selectedFormat = file_formats[ext]
    var reader = new FileReader();
    reader.readAsText(file, "UTF-8");
    reader.onload = function (evt) {
        console.log(evt.target.result);
        gpxFeatures = selectedFormat.readFeatures(evt.target.result, {dataProjection:'EPSG:4326', featureProjection:'EPSG:3857'});
        console.log(gpxFeatures);
        var vectorSource = new ol.source.Vector({
            features: gpxFeatures
        });
        map.addLayer(new ol.layer.Vector({
            shortTitle: "user-data",
            source: vectorSource,
            style: styleFunction
        }));
        map.getView().fit(vectorSource.getExtent());
    }
    $("#dialog").dialog('close');
})
document.getElementById('map').focus();

var onSaveButtonClick = function() {
    $( "#saveDialog" ).dialog();
}
$("#saveFileType").change(function(){
    var selected_option = $('#saveFileType option:selected').text();
    var fname_text = $('#filenameinput').val();
    fname_text = fname_text.substr(0, fname_text.lastIndexOf(".")) +'.'+ selected_option;
    $('#filenameinput').val(fname_text);
})
$('#filenameinput').on('input', function(){
    var fname_text = $('#filenameinput').val();
    var ext = fname_text.substr(fname_text.lastIndexOf(".")+1);
    if(ext === "gpx"){
        $("#saveFileType").val('gpx');
    } else if (ext === "json"){
        $("#saveFileType").val('json');
      //  console.log('dsf');
    } else if (ext === "kml"){
        $("#saveFileType").val('kml');
    }
})

var onSaveDialogButtonClick = function () {
    var ext = $('#saveFileType option:selected').text();
    var format = file_formats[ext];
    var fname = $('#filenameinput').val();
    saveFile(format, fname);
}

/* Context menu */
var centerIcon = '../images/center.png';
var contextmenu = new ContextMenu({
  width: 124,
  defaultItems: false, // defaultItems are (for now) Zoom In/Zoom Out
  items: [
    {
      text: 'Copy Lat/Lon',
      icon: centerIcon,
      callback: coord2clipboard
    }
  ]
});
function coord2clipboard(obj) {
  var coord4326 = ol.proj.transform(obj.coordinate, 'EPSG:3857', 'EPSG:4326');
  var template = '{y}, {x}';
  var latlon = ol.coordinate.format(coord4326, template, 6);
  document.getElementById("coord").value = latlon;
  var copyText = document.querySelector("#coord");
  copyText.type = 'text'; // change the input text field to type="text"
  copyText.select();
  document.execCommand("copy");
  copyText.type = 'hidden'; // change the input field  back to type="hidden"
}
map.addControl(contextmenu);
